#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.UnitTests
{

	/// <summary>
	/// Code for deleting unit test data
	/// </summary>
	static class DataKiller
	{
			

		/// <summary>
		/// Deletes blood unit and associated data created during a test
		/// </summary>
		/// <returns>success indicator (true if 1 or more rows were updated)</returns>
		public static bool ClearBloodUnitData(string bloodUnitGuid)
		{
			StringBuilder query = new StringBuilder();
			query.Append("BEGIN TRANSACTION T2 ");
            query.Append("DELETE FROM IssuedUnit WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
            query.Append("DELETE FROM BloodUnitTest WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
            query.Append("DELETE FROM OrderedUnit WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
            query.Append("DELETE FROM BloodUnitAntigen WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitStatusCodeCurrent WHERE BloodUnitGuid = '").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitStatus WHERE BloodUnitGuid = '").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitFinance WHERE BloodUnitGuid = '").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitCurrentShipment WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitShipment WHERE BloodUnitGuid ='").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnitMedia WHERE BloodUnitGuid = '").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("DELETE FROM BloodUnit WHERE BloodUnitGuid = '").Append(bloodUnitGuid).Append("' ").Append("\n");
			query.Append("COMMIT TRANSACTION T2 ");
			return ( UnitTestUtil.RunSQL(query.ToString()) > 0 );
		}

		
		/// <summary>
		/// Deletes test data
		/// </summary>
		/// <param name="guidMap">
		/// Hashtable of guids used to clear test data
		/// </param>
		/// <returns></returns>
		public static void DeleteCrossmatchedBloodUnitTestData(Hashtable guidMap)
		{
			// Delete test data
			StringBuilder query = new StringBuilder();

			query.Append("BEGIN TRANSACTION T2 ");
			if (guidMap.ContainsKey("orderedUnitGuid"))
			{
				query.Append("DELETE FROM ORDEREDUNIT WHERE OrderedUnitGuid ='").Append(guidMap["orderedUnitGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("orderedComponentGuid"))
			{
				query.Append("DELETE FROM ORDEREDCOMPONENT WHERE OrderedComponentGuid ='").Append(guidMap["orderedComponentGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("specimenTestAboTestOneGuid"))
			{
				query.Append("DELETE FROM SPECIMENTEST WHERE SpecimenTestGuid ='").Append(guidMap["specimenTestAboTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("specimenTestRhTestOneGuid"))
			{
				query.Append("DELETE FROM SPECIMENTEST WHERE SpecimenTestGuid ='").Append(guidMap["specimenTestRhTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("specimenTestAboTestTwoGuid"))
			{
				query.Append("DELETE FROM SPECIMENTEST WHERE SpecimenTestGuid ='").Append(guidMap["specimenTestAboTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("specimenTestRhTestTwoGuid"))
			{
				query.Append("DELETE FROM SPECIMENTEST WHERE SpecimenTestGuid ='").Append(guidMap["specimenTestRhTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientSpecimenTestABScreenGuid"))
			{
				query.Append("DELETE FROM SPECIMENTEST WHERE SpecimenTestGuid ='").Append(guidMap["patientSpecimenTestABScreenGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("orderedTestTestOneGuid"))
			{
				query.Append("DELETE FROM ORDEREDTEST WHERE OrderedTestGuid ='").Append(guidMap["orderedTestTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("orderedTestTestTwoGuid"))
			{
				query.Append("DELETE FROM ORDEREDTEST WHERE OrderedTestGuid ='").Append(guidMap["orderedTestTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientSpecimenTestOneGuid"))
			{
				query.Append("DELETE FROM PATIENTSPECIMEN WHERE PatientSpecimenGuid ='").Append(guidMap["patientSpecimenTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientSpecimenTestTwoGuid"))
			{
				query.Append("DELETE FROM PATIENTSPECIMEN WHERE PatientSpecimenGuid ='").Append(guidMap["patientSpecimenTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientOrderTestOneGuid"))
			{
				query.Append("DELETE FROM PATIENTORDER WHERE PatientOrderGuid ='").Append(guidMap["patientOrderTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientOrderTestTwoGuid"))
			{
				query.Append("DELETE FROM PATIENTORDER WHERE PatientOrderGuid ='").Append(guidMap["patientOrderTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientTreatmentTestOneGuid"))
			{
				query.Append("DELETE FROM PATIENTTREATMENT WHERE PatientTreatmentGuid ='").Append(guidMap["patientTreatmentTestOneGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientTreatmentTestTwoGuid"))
			{
				query.Append("DELETE FROM PATIENTTREATMENT WHERE PatientTreatmentGuid ='").Append(guidMap["patientTreatmentTestTwoGuid"]).Append("' ").Append("\n");
			}
			if (guidMap.ContainsKey("patientGuid"))
			{
				query.Append("DELETE FROM PATIENT WHERE PatientGuid ='").Append(guidMap["patientGuid"]).Append("' ").Append("\n");
			}
			query.Append("COMMIT TRANSACTION T2 ");
			Assert.IsTrue(UnitTestUtil.RunSQL(query.ToString()) > 0);
		}


	}
}
#endif
